 
var kTimecodeFormatterFormatHHMM = 0;
var kTimecodeFormatterFormatHHMMSS = 1;
var kTimecodeFormatterFormatHHMMSSFF = 2;
// var kTimecodeFormatterFormatMMSS1 = 3;
// var kTimecodeFormatterFormatHHMMSS1 = 4;

function TimecodeFormatter(fps, isDropFrame, format) {
	this.isDropFrame = isDropFrame ? isDropFrame : false;
	this.fps = fps ? fps : 0;
	this.format = format != undefined ? format : kTimecodeFormatterFormatHHMMSSFF;

	function pad2(d) {
	    return (d < 10) ? '0' + d.toString() : d.toString();
	}

	this.stringValueForDoubleValue = function(value) {
		if (value != undefined) {
			var isNegative = false;
			var seconds = value;
			var roundingInSeconds = 1.0;
        
	        if (seconds < 0) {
	            isNegative = true;
	            seconds = Math.abs(seconds);
	        }

	        var result = isNegative ? "-" : "";

	        if (this.roundedFPS() == 0) {
	            return "00:00:00:00";
	        }

			switch (this.format) {
				case kTimecodeFormatterFormatHHMMSSFF:
					roundingInSeconds = 1.0 / this.fps;
					break;
				case kTimecodeFormatterFormatHHMM:
					roundingInSeconds = 60.0;
					break;
				// case kTimecodeFormatterFormatMMSS1:
				// case kTimecodeFormatterFormatHHMMSS1:
				// 	roundingInSeconds = 6.0;
				// 	break;
				case kTimecodeFormatterFormatHHMMSS:
					roundingInSeconds = 1.0;
					break;
				default:
					break;
			}
			seconds = Math.round(seconds / roundingInSeconds) * roundingInSeconds;

			switch(this.format) {
	        	case kTimecodeFormatterFormatHHMM:
		        	{
		        		var h = Math.floor(seconds/3600);
		        		seconds -= h * 3600;
		        		var m = Math.floor(seconds/60);
		        		
		        		result += pad2(h) + ":" + pad2(m);
		        	}
	        		break;
	        	case kTimecodeFormatterFormatHHMMSS:
	        		{
		        		var h = Math.floor(seconds/3600);
		        		seconds -= h * 3600;
		        		var m = Math.floor(seconds/60);
		        		seconds -= m * 60;
		        		var s = Math.floor(seconds);

		    			result += pad2(h) + ":" + pad2(m) + ":" + pad2(s);
	        		}
	        		break;
	        	case kTimecodeFormatterFormatHHMMSSFF:
	        		result += this.SMPTETimeForFrameNumber(value * this.fps);
	        		break;
	        	default:
	        		result = "";
	        		break;
	        }
			return result;
		}

		return this.stringValueForDoubleValue(0.0);
	};

	this.doubleValueForStringValue = function(value, format) {
		//TODO:
		return 0.0;
	};

	this.roundedFPS = function() {
		return Math.round(this.fps ? this.fps : 0);
	}

	this.SMPTETimeForFrameNumber = function(frameNumber) {
		var roundedFrameNumber = Math.round(frameNumber);
        var isNegative = false;
        var result = "";
        
        if (roundedFrameNumber < 0) {
            isNegative = true;
            roundedFrameNumber = Math.abs(roundedFrameNumber);
        }

        if (this.roundedFPS() == 0) {
            return "";
        }

        if (this.isDropFrame) {
            var dropFrames  = Math.round(this.roundedFPS() * 0.066666);
            var fpm         = parseInt((this.roundedFPS() * 60 - dropFrames), 10);
            var fpm10       = parseInt((this.roundedFPS() * 10 * 60 - 9 * dropFrames), 10);
            var num10s      = parseInt((roundedFrameNumber / fpm10), 10);
            var frameAdjust = parseInt((num10s * 9 * dropFrames), 10);
            var framesLeft  = parseInt((roundedFrameNumber % fpm10), 10);

            if (framesLeft  >= this.roundedFPS() * 60) {
                framesLeft  = framesLeft -  (this.roundedFPS() * 60);
                var num1s   = parseInt((framesLeft / fpm), 10);
                frameAdjust = frameAdjust + ((num1s + 1) * dropFrames);
            }
            roundedFrameNumber = roundedFrameNumber + frameAdjust;
        }

		var frames  = roundedFrameNumber % this.roundedFPS();
        roundedFrameNumber = parseInt(roundedFrameNumber / this.roundedFPS(), 10);
        
        var seconds = roundedFrameNumber % 60;
        roundedFrameNumber = parseInt(roundedFrameNumber / 60, 10);
                                                     
        var minutes = roundedFrameNumber % 60;
        roundedFrameNumber = parseInt(roundedFrameNumber / 60, 10);
        
        // Limit timecode to 24 hours
        roundedFrameNumber = parseInt(roundedFrameNumber % 24, 10);
        
        var hours = roundedFrameNumber;

        var stringFrames    = pad2(frames);
        var stringSeconds   = pad2(seconds);
        var stringMinutes   = pad2(minutes);
        var stringHours     = pad2(hours);

		result = stringHours + ":" + stringMinutes + ":" + stringSeconds + (this.isDropFrame ? ";" : ":") + stringFrames;	

        return result;
	};
}